/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.api;

import java.util.Base64;
import lombok.NonNull;
import net.skinsrestorer.api.PlayerWrapper;
import net.skinsrestorer.api.SkinVariant;
import net.skinsrestorer.api.exception.SkinRequestException;
import net.skinsrestorer.api.interfaces.IMineSkinAPI;
import net.skinsrestorer.api.interfaces.IMojangAPI;
import net.skinsrestorer.api.interfaces.IPropertyFactory;
import net.skinsrestorer.api.interfaces.ISkinStorage;
import net.skinsrestorer.api.interfaces.IWrapperFactory;
import net.skinsrestorer.api.model.MojangProfileResponse;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.shadow.google.gson.Gson;
import net.skinsrestorer.shadow.jbannotations.Nullable;

public abstract class SkinsRestorerAPI {
    private static SkinsRestorerAPI api;
    private final IMojangAPI mojangAPI;
    private final IMineSkinAPI mineSkinAPI;
    private final ISkinStorage skinStorage;
    private final IPropertyFactory propertyFactory;
    private final Gson gson = new Gson();
    private final IWrapperFactory wrapperFactory;

    protected SkinsRestorerAPI(IMojangAPI mojangAPI, IMineSkinAPI mineSkinAPI, ISkinStorage skinStorage, IWrapperFactory wrapperFactory, IPropertyFactory propertyFactory) {
        if (api == null) {
            SkinsRestorerAPI.setInstance(this);
        }
        this.mojangAPI = mojangAPI;
        this.mineSkinAPI = mineSkinAPI;
        this.skinStorage = skinStorage;
        this.wrapperFactory = wrapperFactory;
        this.propertyFactory = propertyFactory;
    }

    private static synchronized void setInstance(SkinsRestorerAPI api) {
        if (SkinsRestorerAPI.api == null) {
            SkinsRestorerAPI.api = api;
        }
    }

    public static SkinsRestorerAPI getApi() {
        if (api == null) {
            throw new IllegalStateException("SkinsRestorerAPI is not initialized yet!");
        }
        return api;
    }

    public IProperty getProfile(String uuid) {
        return this.mojangAPI.getProfile(uuid).orElse(null);
    }

    public String getSkinName(String playerName) {
        return this.getSkinStorage().getSkinOfPlayer(playerName).orElse(null);
    }

    public boolean hasSkin(String playerName) {
        return this.getSkinName(playerName) != null;
    }

    public void setSkinName(String playerName, String skinName) {
        this.getSkinStorage().setSkinOfPlayer(playerName, skinName);
    }

    public IProperty getSkinData(String skinName) {
        return this.getSkinStorage().getSkinData(skinName).orElse(null);
    }

    @Deprecated
    public void setSkinData(String skinName, IProperty textures, @Nullable Long timestamp) {
        if (timestamp == null) {
            this.setSkinData(skinName, textures);
        } else {
            this.setSkinData(skinName, textures, (long)timestamp);
        }
    }

    public void setSkinData(String skinName, IProperty textures) {
        this.getSkinStorage().setSkinData(skinName, textures);
    }

    public void setSkinData(String skinName, IProperty textures, long timestamp) {
        this.getSkinStorage().setSkinData(skinName, textures, timestamp);
    }

    public IProperty genSkinUrl(String url, @Nullable SkinVariant skinVariant) throws SkinRequestException {
        return this.mineSkinAPI.genSkin(url, skinVariant);
    }

    @Deprecated
    public String getSkinTextureUrl(String skinName) {
        IProperty skin = this.getSkinData(skinName);
        if (skin == null) {
            return null;
        }
        return this.getSkinTextureUrl(skin);
    }

    public String getSkinTextureUrl(@NonNull IProperty property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.getSkinProfileData(property).getTextures().getSKIN().getUrl();
    }

    public String getSkinTextureUrlStripped(@NonNull IProperty property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        return this.getSkinProfileData(property).getTextures().getSKIN().getStrippedUrl();
    }

    public MojangProfileResponse getSkinProfileData(@NonNull IProperty property) {
        if (property == null) {
            throw new NullPointerException("property is marked non-null but is null");
        }
        String decodedString = new String(Base64.getDecoder().decode(property.getValue()));
        return this.gson.fromJson(decodedString, MojangProfileResponse.class);
    }

    public void setSkin(String playerName, String skinName) throws SkinRequestException {
        this.setSkinName(playerName, skinName);
        this.getSkinStorage().getSkinForPlayer(skinName);
    }

    public IProperty createPlatformProperty(IProperty property) {
        return this.createPlatformProperty(property.getName(), property.getValue(), property.getSignature());
    }

    public IProperty createPlatformProperty(String name, String value, String signature) {
        return this.propertyFactory.createProperty(name, value, signature);
    }

    @Deprecated
    public IProperty createProperty(String name, String value, String signature) {
        return this.createPlatformProperty(name, value, signature);
    }

    public void removeSkin(String playerName) {
        this.getSkinStorage().removeSkinOfPlayer(playerName);
    }

    private ISkinStorage getSkinStorage() {
        if (this.skinStorage.isInitialized()) {
            return this.skinStorage;
        }
        throw new IllegalStateException("SkinStorage is not initialized. Is SkinsRestorer in proxy mode?");
    }

    public abstract void applySkin(PlayerWrapper var1) throws SkinRequestException;

    public abstract void applySkin(PlayerWrapper var1, String var2) throws SkinRequestException;

    public abstract void applySkin(PlayerWrapper var1, IProperty var2);

    protected IWrapperFactory getWrapperFactory() {
        return this.wrapperFactory;
    }
}

